<?php
/**
 * Plugin Name: DCW Country Blocker Lite
 * Description: Block or allow by country. Scope: Login only / Admin+Login / Entire Site. Admin bypass, preview bypass, styled block page. Self-hosted updates (PUC) supported.
 * Version: 2.1.7
 * Author: DCWireNet
 * Author URI: https://dcwirenet.com/
 * Text Domain: dcw-country-blocker-lite
 * License: GPL2
 */

if ( ! defined('ABSPATH') ) exit;

define('DCW_CBL_VERSION', '2.1.7');
define('DCW_CBL_DIR', plugin_dir_path(__FILE__));
define('DCW_CBL_URL', plugin_dir_url(__FILE__));

// Safe requires
function dcw_cbl_safe_require( $rel_path ){
    $base = trailingslashit( plugin_dir_path(__FILE__) );
    $path = $base . ltrim($rel_path, '/');
    if ( file_exists($path) ) { require_once $path; return true; }
    add_action('admin_notices', function() use ($rel_path,$path){
        if ( current_user_can('activate_plugins') ) {
            echo '<div class="notice notice-error"><p><strong>DCW Country Blocker Lite</strong>: Missing file <code>' . esc_html($rel_path) . '</code> (looked at <code>' . esc_html($path) . '</code>).</p></div>';
        }
    });
    return false;
}

// Load classes
$ok_admin    = dcw_cbl_safe_require('includes/class-dcw-cbl-admin.php');
$ok_frontend = dcw_cbl_safe_require('includes/class-dcw-cbl-frontend.php');
$ok_cli      = dcw_cbl_safe_require('includes/class-dcw-cbl-cli.php');

if ( $ok_admin && $ok_frontend ) {
    add_action('plugins_loaded', function(){
        DCW_CBL_Admin::init();
        DCW_CBL_Frontend::init();
    });
}

// Settings link in Plugins list
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links){
    $url = admin_url('options-general.php?page=dcw-cbl');
    array_unshift($links, '<a href="' . esc_url($url) . '">Settings</a>');
    return $links;
});

// === Self-hosted updates (PUC) ===
if ( is_admin() ) {
    $dcw_puc_dir   = plugin_dir_path(__FILE__) . 'vendor/plugin-update-checker/';
    $dcw_puc_files = glob( $dcw_puc_dir . 'load-v5p*.php' );
    if ( ! empty( $dcw_puc_files ) ) {
        rsort($dcw_puc_files, SORT_NATURAL);
        require_once $dcw_puc_files[0];
        if ( class_exists('YahnisElsts\PluginUpdateChecker\v5\PucFactory') ) {
            $dcw_cbl_update_checker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
                'https://dcwirenet.com/updates/dcw-cbl-update.json',
                __FILE__,
                'dcw-country-blocker-lite'
            );
            }
    }
}

