<?php
/**
 * Uninstall handler for DCW Country Blocker Lite.
 * Minimal cleanup: delete plugin options when user opted in.
 */

if ( ! defined('WP_UNINSTALL_PLUGIN') ) {
    exit;
}

// Option name used by the plugin.
$option_name = 'dcw_cbl_settings';

// Read current settings (from the main site for single-site).
$settings = get_option( $option_name, [] );

// Respect a toggle like "Delete all plugin data on uninstall".
$should_delete = ! empty( $settings['delete_on_uninstall'] );

// If the toggle isn't present in your UI, set this to true to always delete:
// $should_delete = true;

if ( ! $should_delete ) {
    // User didn't opt-in to data deletion; do nothing.
    return;
}

if ( is_multisite() ) {
    // Remove per-site options across the network.
    $sites = get_sites( [ 'number' => 0 ] );
    foreach ( $sites as $site ) {
        switch_to_blog( (int) $site->blog_id );
        delete_option( $option_name );
        restore_current_blog();
    }
} else {
    // Single site.
    delete_option( $option_name );
}

// Note: Transients/cookies are short-lived and don't require manual cleanup.
// If you introduce custom transients with known keys, you can delete them here
// using delete_transient( 'your_key' ) without direct SQL.
