<?php
/*
Plugin Name: DCW Force HTTPS Lite
Description: Enforce HTTPS redirects for your site with proxy/CDN support and path exclusions.
Version: 1.1.1
Author: DCWireNet
Author URI: https://dcwirenet.com/
Text Domain: dcw-force-https-lite
License: GPL2
*/

if ( ! defined('ABSPATH') ) exit;

define('DCW_FHL_VER', '1.1.1');
define('DCW_FHL_DIR', plugin_dir_path(__FILE__));
define('DCW_FHL_URL', plugin_dir_url(__FILE__));

require_once DCW_FHL_DIR . 'includes/class-dcw-fhl-admin.php';
require_once DCW_FHL_DIR . 'includes/class-dcw-fhl-core.php';

add_action('plugins_loaded', function(){
    DCW_FHL_Admin::init();
    DCW_FHL_Core::init();
});


// === Self-Hosted Updates (safe loader; vendor excluded here) ===
if ( is_admin() ) {
    $dcw_puc_dir   = plugin_dir_path(__FILE__) . 'vendor/plugin-update-checker/';
    $dcw_puc_files = glob( $dcw_puc_dir . 'load-v5p*.php' );

    if ( !empty($dcw_puc_files) ) {
        rsort($dcw_puc_files, SORT_NATURAL);
        $dcw_puc_loader = $dcw_puc_files[0];

        // Optional: sanity-check required files to avoid fatals
        $minor = str_replace('load-', '', basename($dcw_puc_loader, '.php')); // e.g. v5p6
        $need1 = $dcw_puc_dir . 'Puc/' . $minor . '/Autoloader.php';
        $need2 = $dcw_puc_dir . 'Puc/' . $minor . '/PucFactory.php';
        $need3 = $dcw_puc_dir . 'Puc/v5/PucFactory.php';

        if ( file_exists($need1) && file_exists($need2) && file_exists($need3) ) {
            require_once $dcw_puc_loader;

            if ( class_exists('YahnisElsts\\PluginUpdateChecker\\v5\\PucFactory') ) {
                $dcw_fhl_update_checker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
                    'https://dcwirenet.com/updates/dcw-fhl-update.json',
                    __FILE__,
                    'dcw-force-https-lite'
                );

                // Optional: set a homepage/details URL via result filter (works in v5.6)
                if ( method_exists($dcw_fhl_update_checker, 'addResultFilter') ) {
                    $dcw_fhl_update_checker->addResultFilter(function($info) {
                        if ( is_object($info) ) {
                            $info->homepage = 'https://dcwirenet.com/wordpress-plugin#dcw-force-https-lite';
                        }
                        return $info;
                    });
                }
            }
        } else {
            if ( defined('WP_DEBUG') && WP_DEBUG ) {
                    // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
                    error_log('[DCW FHL] debug ...');
                }

        }
    } else {
        // No loader found; skip silently to avoid fatal.
    }
}

/**
 * Force WP to refresh plugin updates when update-check setting changes.
 */
add_action('update_option_dcw_fhl_options', function($old, $new){
    $old_on = !empty($old['enable_update_check']);
    $new_on = !empty($new['enable_update_check']);
    if ($new_on !== $old_on) {
        delete_site_transient('update_plugins'); // force refresh
    }
}, 10, 2);
