<?php
/*
Plugin Name: DCW Login Limit Lite
Description: Lightweight WordPress plugin to limit failed login attempts and block brute force attacks.
Version: 1.1.1
Author: DCWireNet
Author URI: https://dcwirenet.com/
License: GPL2
Text Domain: dcw-login-limit-lite
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'DCW_LLL_PATH', plugin_dir_path( __FILE__ ) );
define( 'DCW_LLL_URL', plugin_dir_url( __FILE__ ) );
define( 'DCW_LLL_VER', '1.1.1' );

require_once DCW_LLL_PATH . 'includes/class-dcw-lll-admin.php';
require_once DCW_LLL_PATH . 'includes/class-dcw-lll-frontend.php';

add_action( 'plugins_loaded', function() {
    DCW_LLL_Admin::init();
    DCW_LLL_Frontend::init();
});

add_action('init', function(){
    load_plugin_textdomain('dcw-login-limit-lite', false, dirname(plugin_basename(__FILE__)) . '/languages');
});

// === DCW Login Limit Lite: Self-Hosted Updates (safe loader) ===
if ( is_admin() ) {
    $dcw_puc_dir   = plugin_dir_path(__FILE__) . 'vendor/plugin-update-checker/';
    $dcw_puc_files = glob( $dcw_puc_dir . 'load-v5p*.php' );

    if ( !empty($dcw_puc_files) ) {
        rsort($dcw_puc_files, SORT_NATURAL);
        $dcw_puc_loader = $dcw_puc_files[0];

        // Optional: sanity-check required files to avoid fatals
        $minor = str_replace('load-', '', basename($dcw_puc_loader, '.php')); // e.g. v5p6
        $need1 = $dcw_puc_dir . 'Puc/' . $minor . '/Autoloader.php';
        $need2 = $dcw_puc_dir . 'Puc/' . $minor . '/PucFactory.php';
        $need3 = $dcw_puc_dir . 'Puc/v5/PucFactory.php';

        if ( file_exists($need1) && file_exists($need2) && file_exists($need3) ) {
            require_once $dcw_puc_loader;

            if ( class_exists('YahnisElsts\\PluginUpdateChecker\\v5\\PucFactory') ) {
                $dcw_lll_update_checker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
                    'https://dcwirenet.com/updates/dcw-lll-update.json',
                    __FILE__,
                    'dcw-login-limit-lite'
                );

                // Optional: set a homepage/details URL via result filter (works in v5.6)
                if ( method_exists($dcw_lll_update_checker, 'addResultFilter') ) {
                    $dcw_lll_update_checker->addResultFilter(function($info) {
                        if ( is_object($info) ) {
                            $info->homepage = 'https://dcwirenet.com/wordpress-plugin#dcw-login-limit-lite';
                        }
                        return $info;
                    });
                }
            }
        } else {
            if ( function_exists('error_log') ) {
                error_log('[DCW LLL] PUC missing required files: ' . $need1 . ' | ' . $need2 . ' | ' . $need3);
            }
        }
    } else {
        // No loader found; skip silently to avoid fatal.
    }
}

/**
 * Force WP to refresh plugin updates when update-check setting changes.
 */
add_action('update_option_dcw_lll_options', function($old, $new){
    $old_on = !empty($old['enable_update_check']);
    $new_on = !empty($new['enable_update_check']);
    if ($new_on !== $old_on) {
        delete_site_transient('update_plugins'); // force refresh
    }
}, 10, 2);

