(function(){
  function pad(n){ return (n<10?'0':'')+n; }
  function tick(){
    var el = document.getElementById('dcw-countdown');
    if(!el) return;
    var endStr = el.getAttribute('data-end');
    if(!endStr) return;
    var end = new Date(endStr.replace(' ', 'T'));
    if (isNaN(end.getTime())) return;
    var now = new Date();
    var diff = end - now;
    if (diff <= 0){ el.textContent = "We're back soon!"; return; }
    var d = Math.floor(diff/(1000*60*60*24));
    var h = Math.floor((diff/(1000*60*60)) % 24);
    var m = Math.floor((diff/(1000*60)) % 60);
    var s = Math.floor((diff/1000) % 60);
    el.textContent = d+"d "+pad(h)+":"+pad(m)+":"+pad(s);
  }
  setInterval(tick, 1000);
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', tick);
  } else {
    tick();
  }
})();
