<?php
/**
 * Plugin Name: DCW Maintenance Mode Lite
 * Description: Lightweight maintenance/coming-soon page with logo, message, countdown, and background options. Title/text color pickers. Preview bypass supported.
 * Version: 1.4.6
 * Author: DCWireNet
 * Author URI: https://dcwirenet.com/
 * Text Domain: dcw-maintenance-mode-lite
 * License: GPL2
 */

if ( ! defined('ABSPATH') ) exit;

// Keep this in sync with the header Version for proper cache-busting
define('DCW_MML_VERSION', '1.4.6');
define('DCW_MML_DIR', plugin_dir_path(__FILE__));
define('DCW_MML_URL', plugin_dir_url(__FILE__));

require_once DCW_MML_DIR . 'includes/class-dcw-mml-admin.php';
require_once DCW_MML_DIR . 'includes/class-dcw-mml-frontend.php';

add_action('plugins_loaded', function(){
    DCW_MML_Admin::init();
    DCW_MML_Frontend::init();
});

register_activation_hook(__FILE__, function(){
    $defaults = [
        'enabled'           => 0,
        'title'             => "We'll be back soon",
        'message'           => '<p>Our site is undergoing scheduled maintenance. Thank you for your patience.</p>',
        'logo'              => '',
        'bg_color'          => '#0f172a',
        'bg_image'          => '',
        'bg_size'           => 'cover',          // cover|contain
        'bg_position'       => 'center center',  // CSS background-position
        'title_color'       => '#ffffff',
        'text_color'        => '#e5e7eb',
        'countdown_enable'  => 0,
        'end_datetime'      => '',               // Y-m-d H:i or Y-m-dTH:i
        // Preview bypass
        'preview_key'       => '',
        'preview_allow_one' => 0,
    ];
    $cur = get_option('dcw_mml_settings');
    update_option('dcw_mml_settings', $cur ? wp_parse_args($cur, $defaults) : $defaults);
});

// === DCW Maintenance Mode Lite: Self-Hosted Updates (safe loader) ===
if ( is_admin() ) {
    $dcw_puc_dir   = plugin_dir_path(__FILE__) . 'vendor/plugin-update-checker/';
    $dcw_puc_files = glob( $dcw_puc_dir . 'load-v5p*.php' );

    if ( !empty($dcw_puc_files) ) {
        rsort($dcw_puc_files, SORT_NATURAL);
        $dcw_puc_loader = $dcw_puc_files[0];

        // Optional: sanity-check required files to avoid fatals
        $minor = str_replace('load-', '', basename($dcw_puc_loader, '.php')); // e.g. v5p6
        $need1 = $dcw_puc_dir . 'Puc/' . $minor . '/Autoloader.php';
        $need2 = $dcw_puc_dir . 'Puc/' . $minor . '/PucFactory.php';
        $need3 = $dcw_puc_dir . 'Puc/v5/PucFactory.php';

        if ( file_exists($need1) && file_exists($need2) && file_exists($need3) ) {
            require_once $dcw_puc_loader;

            if ( class_exists('YahnisElsts\\PluginUpdateChecker\\v5\\PucFactory') ) {
                $dcw_mml_update_checker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
                    'https://dcwirenet.com/updates/dcw-mml-update.json',
                    __FILE__,
                    'dcw-maintenance-mode-lite'
                );

                // Optional: set a homepage/details URL via result filter (works in v5.6)
                if ( method_exists($dcw_mml_update_checker, 'addResultFilter') ) {
                    $dcw_mml_update_checker->addResultFilter(function($info) {
                        if ( is_object($info) ) {
                            $info->homepage = 'https://dcwirenet.com/wordpress-plugin#dcw-maintenance-mode-lite';
                        }
                        return $info;
                    });
                }
            }
        } else {
            if ( function_exists('error_log') ) {
                error_log('[DCW MML] PUC missing required files: ' . $need1 . ' | ' . $need2 . ' | ' . $need3);
            }
        }
    } else {
        // No loader found; skip silently to avoid fatal.
    }
}

